import { IBrowserError } from '../../interfaces/browser/error';

export type HtmlOutput = {
    url?: string,
    statusCode?: number,
    responseHeaders?:{[key: string]: any},
    requestsChain?:{[key: string]: any},
    html?: string,
    requestInterceptions?: Array<{[key: string]: any}>,
    responseInterceptions?: Array<{[key: string]: any}>,
    hyperlinks?: Array<{[key: string]: any}>,
    status?: {[key: string]: any}
    exceptions?: Array<IBrowserError>
}

export interface IHtmlOutputError extends HtmlOutput {
    error: number,
    noinputs?: number   
 }

