import { IBrowserError } from '../../interfaces/browser/error';

export type ClickSearchElement = {
    url?: string,
    querySelector?: string
    statusCode?: number,
    //html: string,
    searchElement?: any,
    listeners?: Array<{[key: string]: any}>,
    responseHeaders?: Record<string, string>,
    requestsChain?:{[key: string]: any},    
    requestInterceptions?: Array<{[key: string]: any}>,
    responseInterceptions?: Array<{[key: string]: any}>,
    hyperlinks?: Array<{[key: string]: any}>,
    status?: {[key: string]: any},
    search_url?: string | any,
    exceptions?: Array<IBrowserError>   
}

export interface IClickSearchElementError extends ClickSearchElement {
    error?: number,
    noinputs?: number   
 }

