export const CVE_URL_STATUS = {
    INVALID: -1,
    NOT_SET: 0,
    SUCCESSFULLY_PROCESSED : 1,
    QUEUED: 2
}

export const CRAWL_STATUS = {
    ERROR: -1,
    NOT_SET: 0,
    COMPLETED: 1    
} 

export const CRAWL_RESULT_TYPE = {
    HTML: 'html',
    PDF: 'pdf'
}

export const AUDIT_TYPE = {
    PERSIST_EXCEPTION: -5,
    GETTING_MORE_WORK_EXCEPTION: -4,
    UNSUPPORTED_HTTP_STATUS_CODE: -3,
    WORKER_UNCAUGHT_EXCEPTION: -2,
    EXCEPTION: -1,    
    CRAWLER_UP_TIME_INFORMATION: 1,
    DUPLICATION_DETECTED: 2,
    NEW_URL_ADDED: 3            
}

//https://nodejs.org/api/errors.html#errors_common_system_errors
export const SYSTEM_ERRORS = {
    ENOTFOUND: 'ENOTFOUND',
    ETIMEDOUT: 'ETIMEDOUT',
    ECONNREFUSED: 'ECONNREFUSED',
    EAI_AGAIN: 'EAI_AGAIN'
}


export const REFERRERS_CRAWLER = {   
AUDIT_TYPES: {      
    PERSIST_EXCEPTION: -5,
    GETTING_MORE_WORK_EXCEPTION: -4,
    HEADLESS_BROWSER_ERROR: -3,
    WORKER_ERROR: -2,
    CRAWLER_MANAGER_ERROR: -1,  
    INFO: 2
},
AUDIT_CONTEXT_MESSAGES: { 

    PREFLIGHT_REQUEST: 'PREFLIGHT_REQUEST',
    STARTING_BROWSER: 'STARTING_BROWSER',

    EXTRACTING_HTML_STEP: 'EXTRACTING_HTML_STEP',
    LOOKUP_INPUTS_STEP: 'LOOKUP_INPUTS_STEP',
    CLICK_SEARCH_INPUT_LOOP_STEP: 'CLICK_SEARCH_INPUT_LOOP_STEP',             
    CLICK_SEARCH_INPUT_LOOP_ANOTHER_TAB_STEP: 'CLICK_SEARCH_INPUT_LOOP_ANOTHER_TAB_STEP',

    LOOKUP_AND_CLICK_SEARCH_INPUT_STEP: 'LOOKUP_AND_CLICK_SEARCH_INPUT_STEP',        
    CLICK_SEARCH_INPUT_STEP: 'CLICK_SEARCH_INPUT_STEP', 
    VISITING_SEARCH_ENDPOINT_STEP: 'VISITING_SEARCH_ENDPOINT_STEP',

    CLOSING_BROWSER: 'CLOSING_BROWSER',
    DOMAIN_VISIT_MAIN: 'DOMAIN_VISIT_MAIN',

    WORKERS_POOL_EXCEPTION: 'WORKERS_POOL_EXCEPTION',
    PARSING_CRAWL_RESULT: 'PARSING_CRAWL_RESULT',
    REDACTING_PAYLOAD_ITEM: 'REDACTING_PAYLOAD_ITEM',
            
    PERSISTING_CRAWL_NOSQL: 'PERSISTING_CRAWL_NOSQL'    
},

CRAWL_STATUS: {
    //queued for processing
    QUEUED: 22, 
    // server response status >= 400 during preflight
    INVALID_HTTP_STATUS_CODE: -3,
    // DNS lookup fails during preflight  
    DNS_ERROR: -2,
    // handled exception occurred.
    ERROR: -1,
    // not processed yet (if found in crawls means unhandled exception probably occurred)
    NOT_SET: 0,
    // the html should be available
    HTML: 1,
    // query selectors lookup matched search alike elements on the page
    SEARCH_INPUTS_FOUND: 2,
    // query selectors lookup did NOT match any search alike elements on the page
    SEARCH_INPUTS_NOT_FOUND: 3,
    // query selectors lookup matched search alike elements on the page BUT they were not valid to type text
    SEARCH_INPUTS_NOT_VALID: 4,
    // means that we got the status where either SEARCH_CLICKS_VALID or SEARCH_URL_ENDPOINT_SUCCESS
    SUCCESS: 5,
    // at least one search input was searched with success
    SEARCH_CLICKS_VALID: 6,
    // zero search input were searched with success (before this was set to -1 ERROR)
    SEARCH_CLICKS_NOT_VALID: 7,
    // search endpoint has been found and ran with success
    SEARCH_URL_ENDPOINT_SUCCESS: 8,
    // search endpoint has been found but has failed
    SEARCH_URL_ENDPOINT_FAILED: 9,
    // the crawl reached to the final step without uncaight exceptions
    COMPLETED: 10     
},

HEADLESS_BROWSER_EXCEPTION_TYPES: {  
    SEARCH_ENDPOINT_URL_EXCEPTION: -5,
    LOOKUP_AND_CLICK_STEP_EXCEPTION: -4,
    CLICK_STEP_EXCEPTION: -3,
    LOOKUP_STEP_EXCEPTION: -2,
    HTML_STEP_EXCEPTION: -1,
    VISITING_PAGE_NETWORK_IDLE: 1, 
    VISITING_PAGE: 2,
    EXTRACTING_LINKS: 3,
    CLOSING_PAGE: 4,
    SETUP_LANGUAGE_FOR_SEARCH_LOOKUPS: 5,
    SEARCH_LOOKUP_LOOP: 6,
    SET_ELEMENT_VISIBLE: 7,
    TYPING_ON_ELEMENT: 8,
    CAPTURING_EVENT_LISTENERS: 9,
    WAITING_FOR_SEARCH_RESULTS_NAVIGATION: 10,
    EXTRACT_SEARCH_RESULTS_URL: 11,
    BUILDING_QUERYSELECTOR: 12,
    PARSING_QUERY_SELECTOR: 13
},

SEARCH_QUERY_SELECTORS: [
    `input[type*="url"]`,
    `input[type*="search"]`,
    `[id*="search" i]`,
    `[class*="search" i]`,    
    `input[type="text"][name*="search" i]`,
    `input[type="search"][name*="search" i]`,
    `input[type="url"][name*="search" i]`,
    `input[type="text"][aria-label*="search" i]`,
    `input[type="search"][aria-label*="search" i]`,
    `input[type="url"][aria-label*="search" i]`,                    
    `input[placeholder*="search" i]`,    
    `input[id*="search" i]`,
    `input[class*="search" i]`,        
    `form[role*="search" i] input`,    
    `form[role*="search" i]`,
    `input[title*="search" i]`,
    `input[name*="search" i]`,
    `a[class*="search" i]`,
    `a[href*="search" i]`, 
    `a[name*="search" i]`,
    `a[id*="search" i]`    
],
SEARCH_ENDPOINT_TYPES: {
    NOT_SET: 0,
    HTML_BODY_EXTRACTED: 1,
},
SEARCH_ENDPOINT_STATUS: {
    NOT_SET: 0
},
IGNORED_PAYLOADS_BY_RESOURCE_TYPES: ['script', 'image', 'font', 'stylesheet', 'audio', 'video', 'other']
,
LANGUAGE_MAPPINGS: {
    countries: [{
        "country": "Andorra",
        "langs": [{
                "full_code": "ca",
                "code": "ca",
                "language": "Catalan; Valencian"
            }
        ],
        "tld": "ad"
    }, {
        "country": "United Arab Emirates",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "fa",
                "code": "fa",
                "language": "Persian"
            }, {
                "full_code": "hi",
                "code": "hi",
                "language": "Hindi"
            }, {
                "full_code": "ur",
                "code": "ur",
                "language": "Urdu"
            }
        ],
        "tld": "ae"
    }, {
        "country": "Armenia",
        "langs": [{
                "full_code": "hy",
                "code": "hy",
                "language": "Armenian"
            }, {
                "full_code": "hy",
                "code": "hy",
                "language": "Armenian"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "am"
    }, {
        "country": "American Samoa",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "as"
    }, {
        "country": "Austria",
        "langs": [{
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "at"
    }, {
        "country": "Azerbaijan",
        "langs": [{
                "full_code": "az",
                "code": "az",
                "language": "Azerbaijani"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "az"
    }, {
        "country": "Bosnia and Herzegovina",
        "langs": [{
                "full_code": "bs",
                "code": "bs",
                "language": "Bosnian"
            }, {
                "full_code": "sr",
                "code": "sr",
                "language": "Serbian"
            }, {
                "full_code": "hr",
                "code": "hr",
                "language": "Croatian"
            }
        ],
        "tld": "ba"
    }, {
        "country": "Belgium",
        "langs": [{
                "full_code": "nl",
                "code": "nl",
                "language": "Dutch"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "be"
    }, {
        "country": "Burkina Faso",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "bf"
    }, {
        "country": "Bulgaria",
        "langs": [{
                "full_code": "bg",
                "code": "bg",
                "language": "Bulgarian"
            }
        ],
        "tld": "bg"
    }, {
        "country": "Burundi",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili"
            }, {
                "full_code": "rn",
                "code": "rn",
                "language": "Kirundi"
            }
        ],
        "tld": "bi"
    }, {
        "country": "Benin",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "yo",
                "code": "yo",
                "language": "Yoruba"
            }
        ],
        "tld": "bj"
    }, {
        "country": "Bahamas",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "bs"
    }, {
        "country": "Belarus",
        "langs": [{
                "full_code": "be",
                "code": "be",
                "language": "Belarusian"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "by"
    }, {
        "country": "Canada",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "ca"
    }, {
        "country": "reserved for the Catalan linguistic and cultural ",
        "langs": [{
                "full_code": "ca",
                "code": "ca",
                "language": "Catalan; Valencian"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "cat"
    }, {
        "country": "\"Congo, The Democratic Republic of the\"",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili"
            }, {
                "full_code": "in",
                "code": "in",
                "language": "Lingala"
            }, {
                "full_code": "ach",
                "code": "ach",
                "language": "Alur"
            }, {
                "full_code": "lua",
                "code": "lua",
                "language": "Tshiluba"
            }, {
                "full_code": "kg",
                "code": "kg",
                "language": "Kongo"
            }
        ],
        "tld": "cd"
    }, {
        "country": "Central African Republic",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "cf"
    }, {
        "country": "Congo",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "in",
                "code": "in",
                "language": "Lingala"
            }, {
                "full_code": "kg",
                "code": "kg",
                "language": "Kongo"
            }
        ],
        "tld": "cg"
    }, {
        "country": "Switzerland",
        "langs": [{
                "full_code": "de",
                "code": "de",
                "language": "German"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "it",
                "code": "it",
                "language": "Italian"
            }, {
                "full_code": "rm",
                "code": "rm",
                "language": "Romansh"
            }
        ],
        "tld": "ch"
    }, {
        "country": "Cote d'Ivoire",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "ci"
    }, {
        "country": "Chile",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "cl"
    }, {
        "country": "Cameroon",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "cm"
    }, {
        "country": "China",
        "langs": [{
                "full_code": "zh-CN",
                "code": "zh",
                "language": "Chinese (Simplified Han)"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "cn"
    }, {
        "country": "Angola",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }, {
                "full_code": "kg",
                "code": "kg",
                "language": "Kongo"
            }
        ],
        "tld": "ao"
    }, {
        "country": "Botswana",
        "langs": [{
                "full_code": "tn",
                "code": "tn",
                "language": "Tswana"
            }
        ],
        "tld": "bw"
    }, {
        "country": "Cook Islands",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ck"
    }, {
        "country": "Costa Rica",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "cr"
    }, {
        "country": "Indonesia",
        "langs": [{
                "full_code": "id",
                "code": "id",
                "language": "Indonesian"
            }, {
                "full_code": "jw",
                "code": "jw",
                "language": "Basa Jawa"
            }
        ],
        "tld": "id"
    }, {
        "country": "Israel",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "iw",
                "code": "iw",
                "language": "Hebrew"
            }
        ],
        "tld": "il"
    }, {
        "country": "India",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "hi",
                "code": "hi",
                "language": "Hindi"
            }, {
                "full_code": "bn",
                "code": "bn",
                "language": "Bengali"
            }, {
                "full_code": "te",
                "code": "te",
                "language": "Telugu"
            }, {
                "full_code": "mr",
                "code": "mr",
                "language": "Marathi (Mar??h?)"
            }, {
                "full_code": "ta",
                "code": "ta",
                "language": "Tamil"
            }, {
                "full_code": "gu",
                "code": "gu",
                "language": "Gujarati"
            }, {
                "full_code": "kn",
                "code": "kn",
                "language": "Kannada"
            }, {
                "full_code": "ml",
                "code": "ml",
                "language": "Malayalam"
            }, {
                "full_code": "pa",
                "code": "pa",
                "language": "Panjabi, Punjabi\"\r\n"
            }
        ],
        "tld": "in"
    }, {
        "country": "Japan",
        "langs": [{
                "full_code": "ja",
                "code": "ja",
                "language": "Japanese"
            }
        ],
        "tld": "jp"
    }, {
        "country": "Kenya",
        "langs": [{
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili"
            }
        ],
        "tld": "ke"
    }, {
        "country": "\"Korea, Republic of\"",
        "langs": [{
                "full_code": "ko",
                "code": "ko",
                "language": "Korean"
            }
        ],
        "tld": "kr"
    }, {
        "country": "Lesotho",
        "langs": [{
                "full_code": "st",
                "code": "st",
                "language": "Southern Sotho"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ls"
    }, {
        "country": "Morocco",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "ma"
    }, {
        "country": "Mozambique",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }, {
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili or Kiswahilior Kiswahili"
            }, {
                "full_code": "ny",
                "code": "ny",
                "language": "Chichewa; Chewa; Nyanja;Chinyanja"
            }, {
                "full_code": "sn",
                "code": "sn",
                "language": "Shona"
            }
        ],
        "tld": "mz"
    }, {
        "country": "New Zealand",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "mi",
                "code": "mi",
                "language": "M?ori"
            }
        ],
        "tld": "nz"
    }, {
        "country": "Thailand",
        "langs": [{
                "full_code": "th",
                "code": "th",
                "language": "Thai"
            }
        ],
        "tld": "th"
    }, {
        "country": "\"Tanzania, United Republic of\"",
        "langs": [{
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili or Kiswahilior Kiswahili"
            }
        ],
        "tld": "tz"
    }, {
        "country": "Uganda",
        "langs": [{
                "full_code": "lg",
                "code": "lg",
                "language": "Ganda"
            }, {
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili"
            }, {
                "full_code": "rw",
                "code": "rw",
                "language": "Kinyarwanda"
            }, {
                "full_code": "ach",
                "code": "ach",
                "language": "Luo"
            }, {
                "full_code": "nym",
                "code": "nym",
                "language": "Runyakitara"
            }
        ],
        "tld": "ug"
    }, {
        "country": "United Kingdom",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "uk"
    }, {
        "country": "Uzbekistan",
        "langs": [{
                "full_code": "uz",
                "code": "uz",
                "language": "Uzbek"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "uz"
    }, {
        "country": "\"Venezuela, Bolivarian Republic of\"",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "ve"
    }, {
        "country": "\"Virgin Islands, U.S.\"",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "vi"
    }, {
        "country": "South Africa",
        "langs": [{
                "full_code": "af",
                "code": "af",
                "language": "Afrikaans"
            }, {
                "full_code": "st",
                "code": "st",
                "language": "Southern Sotho or Sesotho"
            }, {
                "full_code": "zu",
                "code": "zu",
                "language": "Zulu or IsiZulu"
            }, {
                "full_code": "xh",
                "code": "xh",
                "language": "Xhosa or IsiXhosa"
            }, {
                "full_code": "tn",
                "code": "tn",
                "language": "Tswana or Setswana"
            }, {
                "full_code": "nso",
                "code": "nso",
                "language": "Northern Sotho"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "za"
    }, {
        "country": "Zambia",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "ny",
                "code": "ny",
                "language": "Chichewa; Chewa; Nyanja"
            }, {
                "full_code": "bem",
                "code": "bem",
                "language": "IciBemba"
            }, {
                "full_code": "tum",
                "code": "tum",
                "language": "Chitumbuka-Chisenga"
            }, {
                "full_code": "loz",
                "code": "loz",
                "language": "Silozi"
            }
        ],
        "tld": "zm"
    }, {
        "country": "Zimbabwe",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "sn",
                "code": "sn",
                "language": "Shona"
            }, {
                "full_code": "zu",
                "code": "zu",
                "language": "Zulu"
            }, {
                "full_code": "ny",
                "code": "ny",
                "language": "Chichewa; Chewa; Nyanja"
            }
        ],
        "tld": "zw"
    }, {
        "country": "United States",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "com"
    }, {
        "country": "Afghanistan",
        "langs": [{
                "full_code": "fa",
                "code": "fa",
                "language": "Persian"
            }, {
                "full_code": "ps",
                "code": "ps",
                "language": "Pashto, Pushto\""
            }
        ],
        "tld": "af"
    }, {
        "country": "Antigua and Barbuda",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ag"
    }, {
        "country": "Anguilla",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ai"
    }, {
        "country": "Argentina",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "ar"
    }, {
        "country": "Australia",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "au"
    }, {
        "country": "Bangladesh",
        "langs": [{
                "full_code": "bn",
                "code": "bn",
                "language": "Bengali"
            }
        ],
        "tld": "bd"
    }, {
        "country": "Bahrain",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "bh"
    }, {
        "country": "Brunei Darussalam",
        "langs": [{
                "full_code": "ms",
                "code": "ms",
                "language": "Malay"
            }, {
                "full_code": "zh-cn",
                "code": "zh",
                "language": "Chinese (Simplified Han)"
            }
        ],
        "tld": "bn"
    }, {
        "country": "Bolivia",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }, {
                "full_code": "qu",
                "code": "qu",
                "language": "Quechua"
            }
        ],
        "tld": "bo"
    }, {
        "country": "Brazil",
        "langs": [{
                "full_code": "pt-BR",
                "code": "pt",
                "language": "Portuguese (Brasil)"
            }
        ],
        "tld": "br"
    }, {
        "country": "Belize",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "bz"
    }, {
        "country": "Colombia",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "co"
    }, {
        "country": "Cuba",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "cu"
    }, {
        "country": "Cyprus",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "el",
                "code": "el",
                "language": "Greek, Modern\""
            }, {
                "full_code": "tr",
                "code": "tr",
                "language": "Turkish"
            }
        ],
        "tld": "cy"
    }, {
        "country": "Dominican Republic",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "do"
    }, {
        "country": "Ecuador",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "ec"
    }, {
        "country": "Egypt",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "eg"
    }, {
        "country": "Ethiopia",
        "langs": [{
                "full_code": "am",
                "code": "am",
                "language": "Amharic"
            }, {
                "full_code": "ti",
                "code": "ti",
                "language": "Tigrinya"
            }, {
                "full_code": "so",
                "code": "so",
                "language": "Somali"
            }, {
                "full_code": "om",
                "code": "om",
                "language": "Oromo"
            }
        ],
        "tld": "et"
    }, {
        "country": "Fiji",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "fj"
    }, {
        "country": "Ghana",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "ha",
                "code": "ha",
                "language": "Hausa"
            }, {
                "full_code": "ak",
                "code": "ak",
                "language": "Akan"
            }, {
                "full_code": "ee",
                "code": "ee",
                "language": "Ewe"
            }, {
                "full_code": "gaa",
                "code": "gaa",
                "language": "Ga"
            }
        ],
        "tld": "gh"
    }, {
        "country": "Gibraltar",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "es",
                "code": "es",
                "language": "Spanish; Castilian"
            }, {
                "full_code": "it",
                "code": "it",
                "language": "Italian"
            }, {
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }
        ],
        "tld": "gi"
    }, {
        "country": "Guatemala",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "gt"
    }, {
        "country": "Hong Kong",
        "langs": [{
                "full_code": "zh-TW",
                "code": "zh",
                "language": "Chinese (Traditional Han)"
            }
        ],
        "tld": "hk"
    }, {
        "country": "Jamaica",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "jM"
    }, {
        "country": "Cambodia",
        "langs": [{
                "full_code": "km",
                "code": "km",
                "language": "Khmer"
            }
        ],
        "tld": "kh"
    }, {
        "country": "Kuwait",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "kw"
    }, {
        "country": "Lebanon",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "hy",
                "code": "hy",
                "language": "Armenian"
            }
        ],
        "tld": "lb"
    }, {
        "country": "Libya",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "it",
                "code": "it",
                "language": "Italian"
            }
        ],
        "tld": "ly"
    }, {
        "country": "Malta",
        "langs": [{
                "full_code": "mt",
                "code": "mt",
                "language": "Maltese"
            }
        ],
        "tld": "mt"
    }, {
        "country": "Mexico",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "mx"
    }, {
        "country": "Malaysia",
        "langs": [{
                "full_code": "ms",
                "code": "ms",
                "language": "Malay"
            }
        ],
        "tld": "my"
    }, {
        "country": "Namibia",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "af",
                "code": "af",
                "language": "Afrikaans"
            }, {
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "na"
    }, {
        "country": "Norfolk Island",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "nf"
    }, {
        "country": "Nigeria",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "ha",
                "code": "ha",
                "language": "Hausa"
            }, {
                "full_code": "ig",
                "code": "ig",
                "language": "Igbo"
            }, {
                "full_code": "yo",
                "code": "yo",
                "language": "Yoruba"
            }, {
                "full_code": "pcm",
                "code": "pcm",
                "language": "Pidgin"
            }
        ],
        "tld": "ng"
    }, {
        "country": "Nicaragua",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "ni"
    }, {
        "country": "Nepal",
        "langs": [{
                "full_code": "ne",
                "code": "ne",
                "language": "Nepali"
            }
        ],
        "tld": "np"
    }, {
        "country": "Oman",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "om"
    }, {
        "country": "Panama",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "pa"
    }, {
        "country": "Peru",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }, {
                "full_code": "qu",
                "code": "qu",
                "language": "Quechua"
            }
        ],
        "tld": "pe"
    }, {
        "country": "Philippines",
        "langs": [{
                "full_code": "tl",
                "code": "tl",
                "language": "Tagalog"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "ph"
    }, {
        "country": "Pakistan",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "ur",
                "code": "ur",
                "language": "Urdu"
            }
        ],
        "tld": "pk"
    }, {
        "country": "Puerto Rico",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "pr"
    }, {
        "country": "Paraguay",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "py"
    }, {
        "country": "Qatar",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "qa"
    }, {
        "country": "Saudi Arabia",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "sa"
    }, {
        "country": "Solomon Islands",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "sb"
    }, {
        "country": "Singapore",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "zh-cn",
                "code": "zh",
                "language": "Chinese (Simplified Han)"
            }, {
                "full_code": "ms",
                "code": "ms",
                "language": "Malay"
            }, {
                "full_code": "ta",
                "code": "ta",
                "language": "Tamil"
            }
        ],
        "tld": "sg"
    }, {
        "country": "Sierra Leone",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "kri",
                "code": "kri",
                "language": "Krio"
            }
        ],
        "tld": "sl"
    }, {
        "country": "El Salvador",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "sv"
    }, {
        "country": "Tajikistan",
        "langs": [{
                "full_code": "tg",
                "code": "tg",
                "language": "Tajik"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "tj"
    }, {
        "country": "Turkey",
        "langs": [{
                "full_code": "tr",
                "code": "tr",
                "language": "Turkish"
            }
        ],
        "tld": "tr"
    }, {
        "country": "\"Taiwan, Province of China\"",
        "langs": [{
                "full_code": "zh",
                "code": "zh",
                "language": "Chinese"
            }
        ],
        "tld": "tw"
    }, {
        "country": "Ukraine",
        "langs": [{
                "full_code": "uk",
                "code": "uk",
                "language": "Ukrainian"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "ua"
    }, {
        "country": "Uruguay",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "uy"
    }, {
        "country": "Saint Vincent and the Grenadines",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "vc"
    }, {
        "country": "Viet Nam",
        "langs": [{
                "full_code": "vi",
                "code": "vi",
                "language": "Vietnamese"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "zh-TW",
                "code": "zh",
                "language": "Chinese (Traditional Han)"
            }
        ],
        "tld": "vn"
    }, {
        "country": "Cape Verde",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }
        ],
        "tld": "cv"
    }, {
        "country": "Czech Republic",
        "langs": [{
                "full_code": "cs",
                "code": "cs",
                "language": "Czech"
            }
        ],
        "tld": "cz"
    }, {
        "country": "Germany",
        "langs": [{
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "de"
    }, {
        "country": "Djibouti",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "so",
                "code": "so",
                "language": "Somali"
            }
        ],
        "tld": "dj"
    }, {
        "country": "Denmark",
        "langs": [{
                "full_code": "da",
                "code": "da",
                "language": "Danish"
            }, {
                "full_code": "fo",
                "code": "fo",
                "language": "Faroese"
            }
        ],
        "tld": "dk"
    }, {
        "country": "Dominica",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "d"
    }, {
        "country": "Algeria",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "dz"
    }, {
        "country": "Estonia",
        "langs": [{
                "full_code": "et",
                "code": "et",
                "language": "Estonian"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "ee"
    }, {
        "country": "Spain",
        "langs": [{
                "full_code": "es",
                "code": "es",
                "language": "Spanish; Castilian"
            }, {
                "full_code": "ca",
                "code": "ca",
                "language": "Catalan; Valencian"
            }, {
                "full_code": "gl",
                "code": "gl",
                "language": "Galician"
            }, {
                "full_code": "eu",
                "code": "eu",
                "language": "Basque"
            }
        ],
        "tld": "es"
    }, {
        "country": "Finland",
        "langs": [{
                "full_code": "fi",
                "code": "fi",
                "language": "Finnish"
            }, {
                "full_code": "sv",
                "code": "sv",
                "language": "Swedish"
            }
        ],
        "tld": "fi"
    }, {
        "country": "Micronesia",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "f"
    }, {
        "country": "France",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "fr"
    }, {
        "country": "Gabon",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "ga"
    }, {
        "country": "Georgia",
        "langs": [{
                "full_code": "ka",
                "code": "ka",
                "language": "Georgian"
            }
        ],
        "tld": "ge"
    }, {
        "country": "Guersney",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "gg"
    }, {
        "country": "Greenland",
        "langs": [{
                "full_code": "da",
                "code": "da",
                "language": "Danish"
            }
        ],
        "tld": "gl"
    }, {
        "country": "Gambia",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "wo",
                "code": "wo",
                "language": "Wolof"
            }
        ],
        "tld": "gm"
    }, {
        "country": "Guadeloupe",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "gp"
    }, {
        "country": "Greece",
        "langs": [{
                "full_code": "el",
                "code": "el",
                "language": "Greek, Modern\""
            }
        ],
        "tld": "gr"
    }, {
        "country": "Guyana",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "gy"
    }, {
        "country": "Honduras",
        "langs": [{
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }
        ],
        "tld": "hn"
    }, {
        "country": "Croatia",
        "langs": [{
                "full_code": "hr",
                "code": "hr",
                "language": "Croatian"
            }
        ],
        "tld": "hr"
    }, {
        "country": "Haiti",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ht",
                "code": "ht",
                "language": "Haitian; Haitian Creole or Kreyòl Ayisyen"
            }
        ],
        "tld": "ht"
    }, {
        "country": "Hungary",
        "langs": [{
                "full_code": "hu",
                "code": "hu",
                "language": "Hungarian"
            }
        ],
        "tld": "hu"
    }, {
        "country": "Ireland",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "ga",
                "code": "ga",
                "language": "Irish"
            }
        ],
        "tld": "ie"
    }, {
        "country": "Isle of Man",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "im"
    }, {
        "country": "Iraq",
        "langs": [{
                "full_code": "ckb",
                "code": "ckb",
                "language": "Kurdish"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "iq"
    }, {
        "country": "Iceland",
        "langs": [{
                "full_code": "is",
                "code": "is",
                "language": "Icelandic"
            }
        ],
        "tld": "is"
    }, {
        "country": "Italy",
        "langs": [{
                "full_code": "it",
                "code": "it",
                "language": "Italian"
            }
        ],
        "tld": "it"
    }, {
        "country": "Jersey",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "je"
    }, {
        "country": "Jordan",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "jo"
    }, {
        "country": "Kyrgyzstan",
        "langs": [{
                "full_code": "ky",
                "code": "ky",
                "language": "Kyrgyz"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "kg"
    }, {
        "country": "Kiribati",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ki"
    }, {
        "country": "Kazakhstan",
        "langs": [{
                "full_code": "kk",
                "code": "kk",
                "language": "Kazakh"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "kz"
    }, {
        "country": "Lao People\\'s Democratic Republic",
        "langs": [{
                "full_code": "lo",
                "code": "lo",
                "language": "Lao"
            }
        ],
        "tld": "la"
    }, {
        "country": "Liechtenstein",
        "langs": [{
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "li"
    }, {
        "country": "Sri Lanka",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "si",
                "code": "si",
                "language": "Sinhala, Sinhalese\""
            }, {
                "full_code": "ta",
                "code": "ta",
                "language": "Tamil"
            }
        ],
        "tld": "lk"
    }, {
        "country": "Lithuania",
        "langs": [{
                "full_code": "lt",
                "code": "lt",
                "language": "Lithuanian"
            }
        ],
        "tld": "lt"
    }, {
        "country": "Luxembourg",
        "langs": [{
                "full_code": "de",
                "code": "de",
                "language": "German"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "lu"
    }, {
        "country": "Latvia",
        "langs": [{
                "full_code": "lv",
                "code": "lv",
                "language": "Latvian"
            }, {
                "full_code": "lt",
                "code": "lt",
                "language": "Lithuanian"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "lv"
    }, {
        "country": "\"Moldova, Republic of\"",
        "langs": [{
                "full_code": "mo",
                "code": "mo",
                "language": "Moldovan"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "md"
    }, {
        "country": "Montenegro",
        "langs": [{
                "full_code": "sr-ME",
                "code": "sr",
                "language": "Montenegro"
            }, {
                "full_code": "sr",
                "code": "sr",
                "language": "Serbian"
            }, {
                "full_code": "bs",
                "code": "bs",
                "language": "Bosnian"
            }
        ],
        "tld": "me"
    }, {
        "country": "Madagascar",
        "langs": [{
                "full_code": "mg",
                "code": "mg",
                "language": "Malagasy"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "mg"
    }, {
        "country": "\"Macedonia, The Former Yugoslav Republic of\\nspons\"",
        "langs": [{
                "full_code": "mk",
                "code": "mk",
                "language": "Macedonian"
            }
        ],
        "tld": "mk"
    }, {
        "country": "Mali",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "ml"
    }, {
        "country": "Mongolia",
        "langs": [{
                "full_code": "mn",
                "code": "mn",
                "language": "Mongolian"
            }
        ],
        "tld": "mn"
    }, {
        "country": "Montserrat",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ms"
    }, {
        "country": "Mauritius",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "mfe",
                "code": "mfe",
                "language": "Kreol morisien"
            }
        ],
        "tld": "mu"
    }, {
        "country": "Maldives",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "",
                "code": "",
                "language": ""
            }
        ],
        "tld": "mv"
    }, {
        "country": "Malawi",
        "langs": [{
                "full_code": "ny",
                "code": "ny",
                "language": "Chichewa; Chewa; Nyanja"
            }, {
                "full_code": "tum",
                "code": "tum",
                "language": ""
            }
        ],
        "tld": "mw"
    }, {
        "country": "Niger",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ha",
                "code": "ha",
                "language": "Hausa"
            }
        ],
        "tld": "ne"
    }, {
        "country": "Netherlands",
        "langs": [{
                "full_code": "nl",
                "code": "nl",
                "language": "Dutch"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "nl"
    }, {
        "country": "Norway",
        "langs": [{
                "full_code": "no",
                "code": "no",
                "language": "Norwegian"
            }, {
                "full_code": "nn",
                "code": "nn",
                "language": "Norwegian Nynorsk"
            }
        ],
        "tld": "no"
    }, {
        "country": "Nauru",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "nr"
    }, {
        "country": "Niue",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "nu"
    }, {
        "country": "Poland",
        "langs": [{
                "full_code": "pl",
                "code": "pl",
                "language": "Polish"
            }
        ],
        "tld": "pl"
    }, {
        "country": "Pitcairn",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "pn"
    }, {
        "country": "\"Palestinian Territory, Occupied\"",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "ps"
    }, {
        "country": "Portugal",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }
        ],
        "tld": "pt"
    }, {
        "country": "Romania",
        "langs": [{
                "full_code": "ro",
                "code": "ro",
                "language": "Romanian, Moldavian, Moldovan\""
            }, {
                "full_code": "hu",
                "code": "hu",
                "language": "Hungarian"
            }, {
                "full_code": "de",
                "code": "de",
                "language": "German"
            }
        ],
        "tld": "ro"
    }, {
        "country": "Serbia",
        "langs": [{
                "full_code": "sr",
                "code": "sr",
                "language": "Serbian"
            }
        ],
        "tld": "rs"
    }, {
        "country": "Russia",
        "langs": [{
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }
        ],
        "tld": "ru"
    }, {
        "country": "Rwanda",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "sw",
                "code": "sw",
                "language": "Swahili"
            }, {
                "full_code": "rw",
                "code": "rw",
                "language": "Kinyarwanda"
            }
        ],
        "tld": "rw"
    }, {
        "country": "Seychelles",
        "langs": [{
                "full_code": "crs",
                "code": "crs",
                "language": "Kreol Seselwa "
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "sc"
    }, {
        "country": "Sweden",
        "langs": [{
                "full_code": "sv",
                "code": "sv",
                "language": "Swedish"
            }
        ],
        "tld": "se"
    }, {
        "country": "Saint Helena",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "sh"
    }, {
        "country": "Slovenia",
        "langs": [{
                "full_code": "sl",
                "code": "sl",
                "language": "Slovene"
            }
        ],
        "tld": "si"
    }, {
        "country": "Slovakia",
        "langs": [{
                "full_code": "sk",
                "code": "sk",
                "language": "Slovak"
            }
        ],
        "tld": "sk"
    }, {
        "country": "San Marino",
        "langs": [{
                "full_code": "it",
                "code": "it",
                "language": "Italian"
            }
        ],
        "tld": "sm"
    }, {
        "country": "Senegal",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "wo",
                "code": "wo",
                "language": "Wolof"
            }
        ],
        "tld": "sn"
    }, {
        "country": "Somalia",
        "langs": [{
                "full_code": "so",
                "code": "so",
                "language": "Somali"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "so"
    }, {
        "country": "Sao Tome and Principe",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }
        ],
        "tld": "st"
    }, {
        "country": "Chad",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }
        ],
        "tld": "td"
    }, {
        "country": "Togo",
        "langs": [{
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "ee",
                "code": "ee",
                "language": "Ewe"
            }
        ],
        "tld": "tg"
    }, {
        "country": "Tokelau",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "tk"
    }, {
        "country": "Timor-Leste",
        "langs": [{
                "full_code": "pt-PT",
                "code": "pt",
                "language": "Portuguese"
            }
        ],
        "tld": "tl"
    }, {
        "country": "Turkmenistan",
        "langs": [{
                "full_code": "tk",
                "code": "tk",
                "language": "Turkmen"
            }, {
                "full_code": "ru",
                "code": "ru",
                "language": "Russian"
            }, {
                "full_code": "uz",
                "code": "uz",
                "language": "Uzbek"
            }
        ],
        "tld": "tm"
    }, {
        "country": "Tunisia",
        "langs": [{
                "full_code": "ar",
                "code": "ar",
                "language": "Arabic"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "tn"
    }, {
        "country": "Tonga",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "to",
                "code": "to",
                "language": "Tonga (Tonga Islands)"
            }
        ],
        "tld": "to"
    }, {
        "country": "Trinidad and Tobago",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "hi",
                "code": "hi",
                "language": "Hindi"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }, {
                "full_code": "es-419",
                "code": "es",
                "language": "Español (Latinoamérica)"
            }, {
                "full_code": "zh-tw",
                "code": "zh",
                "language": "Chinese (Traditional Han)"
            }
        ],
        "tld": "tt"
    }, {
        "country": "\"Virgin Islands, British\"",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "vg"
    }, {
        "country": "Vanuatu",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }, {
                "full_code": "fr",
                "code": "fr",
                "language": "French"
            }
        ],
        "tld": "vu"
    }, {
        "country": "Samoa",
        "langs": [{
                "full_code": "en",
                "code": "en",
                "language": "English"
            }
        ],
        "tld": "ws"
    }
    ], 
    search_terms : {
        "fr": "Chercher",
        "ach": "Yeny",
        "af": "Soek",
        "sq": "Kërkoni",
        "hy-AM": "Որոնում",
        "hy": "Որոնում",
        "hye": "Որոնում",
        "frp": "Chèrchér",
        "as": "সন্ধান কৰক",
        "az": "Axtar",
        "eu": "Bilatu",
        "be": "Шукаць",
        "bn": "অনুসন্ধান করুন",
        "brx": "नागिर",
        "bs": "Pretraga",
        "br": "Klask",
        "bg": "Търсене",
        "my": "ရှာဖွေပါ",
        "ca": "Cerca",
        "ca-valencia": "Cerca",
        "calencia": "Cerca",
        "zh-CN": "搜索",
        "zh": "搜尋",
        "zh-TW": "搜尋",
        "crh": "Arama",
        "hr": "Traži",
        "cs": "Hledat",
        "da": "Søg",
        "nl": "Zoeken",
        "en-CA": "Search",
        "en": "Search",
        "en-GB": "Search",
        "eo": "Serĉi",
        "et": "Otsi",
        "fi": "Haku",
        "fy-NL": "Sykje",
        "fy": "Sykje",
        "ff": "Yiylo",
        "gd": "Lorg",
        "ka": "ძიება",
        "de": "Suchen",
        "el": "Αναζήτηση",
        "gn": "Heka",
        "gu-IN": "શોધો",
        "gu": "શોધો",
        "hi-IN": "खोजें",
        "hi": "खोजें",
        "hu": "Keresés",
        "is": "Leita",
        "id": "Cari",
        "ia": "Cercar",
        "ga-IE": "Cuardaigh",
        "ga": "Cuardaigh",
        "it": "Cerca",
        "ixl": "Chuka",
        "ja": "検索",
        "kab": "Nadi",
        "cak": "Tikanöx",
        "kk": "Іздеу",
        "km": "ស្វែងរក",
        "ko": "검색",
        "ltg": "Mekleit",
        "lv": "Meklēt",
        "lij": "Çerca",
        "lt": "Ieškoti",
        "ml": "തെരയുക",
        "mr": "शोधा",
        "meh": "Nánuku",
        "mix": "Nduku",
        "ne-NP": "खोज्नुहोस्",
        "ne": "खोज्नुहोस्",
        "nb-NO": "Søk",
        "nb": "Søk",
        "nn-NO": "Søk",
        "nn": "Søk",
        "oc": "Recercar",
        "or": "ଖୋଜନ୍ତୁ",
        "pl": "Szukaj",
        "pt-BR": "Pesquisar",
        "pt": "Pesquisar",
        "pt-PT": "Pesquisar",
        "pa-IN": "ਖੋਜ",
        "pa": "ਖੋਜ",
        "ro": "Caută",
        "rm": "Tschertgar",
        "ru": "Поиск",
        "sr": "Претражи",
        "scn": "Cerca",
        "si": "සොයන්න",
        "sk": "Hľadať",
        "sl": "Išči",
        "dsb": "Pytaś",
        "hsb": "Pytać",
        "es-AR": "Buscar",
        "es": "Buscar",
        "es-CL": "Buscar",
        "es-MX": "Buscar",
        "es-ES": "Buscar",
        "sv-SE": "Sök",
        "sv": "Sök",
        "tl": "Hanapin",
        "ta": "தேடு",
        "te": "వెతకండి",
        "th": "ค้นหา",
        "trs": "Nanà'uì'",
        "tr": "Arama",
        "uk": "Пошук",
        "uz": "Qidirish",
        "vi": "Tìm kiếm",
        "cy": "Chwilio"
    }
} as {[key: string]: any}



}
