import * as mongoose from 'mongoose';

const WorkItemsSchema = new mongoose.Schema({
    domain: {type:String},
    runId: {type:String},     
    start: {type:Date},
    end: {type:Date}    
}, {timestamps: true});

WorkItemsSchema.methods.toWeb = function(){
    let json = this.toJSON();
    json.id = this._id;
    return {      
        'id': this._id,
        'domain': json.domain,
        'runId': json.runId,
        'start': json.start ? new Date(json.start) : undefined,
        'end': json.end ? new Date(json.end) : undefined     
    };
}

const WorkItems = mongoose.model('WorkItems', WorkItemsSchema);

export default WorkItems;