import * as mongoose from 'mongoose';

const SearchEndpointsSchema = new mongoose.Schema({
    domain: {type: String},
    url: {type: String},
    regexMatch: {type: String},
    type: {type: Number},
    status: {type: Number},
    runId: {type: String}
}, {timestamps: true});

SearchEndpointsSchema.methods.toWeb = function(){
    let json = this.toJSON();
    json.id = this._id;
    return {      
        'domain': json.domain,
        'url': json.url,
        'regexMatch': json.regexMatch,
        'type': json.type,
        'status': json.status,
        'runId': json.runId
    };
}

const SearchEndpoints = mongoose.model('Search_Endpoints', SearchEndpointsSchema);

export default SearchEndpoints;