import * as mongoose from 'mongoose';

const ReferrersSchema = new mongoose.Schema({
    rank: {type:Number},
    domain: {type: String},
    status: {type: Number},
    lastRunId: {type: String}
}, {timestamps: true});

ReferrersSchema.methods.toWeb = function(){
    let json = this.toJSON();
    json.id = this._id;
    return {    
        'rank': json.rank,
        'domain': json.domain,
        'status': json.status,
        'lastRunId': json.lastRunId
    };
}

const Referrers = mongoose.model('Referrers', ReferrersSchema);

export default Referrers;