import * as mongoose from 'mongoose';

const CrawlsSchema = new mongoose.Schema({
    domain: {type:String},    
    url: {type:String},
    lang_codes: {type:String},
    search_inputs: {type:String},
    search_clicks: {type:String},
    html: {type: String},    
    status: {type: Number},
    start: {type: Date},
    end: {type: Date},
    runId: {type: String}   
}, {timestamps: true});

CrawlsSchema.methods.toWeb = function(){
    let json = this.toJSON();
    json.id = this._id;
    return {      
        'domain': json.domain,
        'url': json.url,
        'lang_codes': json.lang_codes,
        'search_inputs': JSON.parse(json.search_inputs),
        'search_clicks': JSON.parse(json.search_clicks),
        'html': JSON.parse(json.html),
        'status': json.status,
        'start': json.start,
        'end': json.end,
        'runId': json.runId
    };
}

const Crawls = mongoose.model('Crawls', CrawlsSchema);

export default Crawls;