import * as mongoose from 'mongoose';

const AuditsSchema = new mongoose.Schema({
    domain: {type:String},
    type: {type: Number},
    context: {type: String},    
    metadata: {type:String},        
    preFlightHttpCode: {type:Number},
    htmlHttpCode: {type:Number},                
    html_step_status: {type:Number},
    lookup_step_status: {type:Number},           			             
    clicks_search_step_status: {type:Number},
    search_endpoint_step_status: {type:Number},
    startCrawlTime: {type:Date},
    endCrawlTime: {type:Date},
    runId: {type: String}
}, {timestamps: true});

AuditsSchema.methods.toWeb = function(){
    let json = this.toJSON();
    json.id = this._id;
    return {        
        'domain':  json.domain,
        'type':  json.type,
        'context': json.context,
        'metadata': json.metadata,
        'preFlightHttpCode': json.preFlightHttpCode,
        'htmlHttpCode': json.htmlHttpCode,
        'html_step_status': json.html_step_status,
        'lookup_step_status': json.lookup_step_status,
        'clicks_search_step_status': json.clicks_search_step_status,
        'search_endpoint_step_status': json.search_endpoint_step_status,
        'startCrawlTime': new Date(json.startCrawlTime),
        'endCrawlTime': new Date(json.endCrawlTime),
        'runId': json.runId    
    };
}

const Audits = mongoose.model('Audits', AuditsSchema);

export default Audits;