import { ICrawlOutput } from '../core/crawl-output.interface'; 
import { HtmlOutput } from 'referrers/html-output';
import { ClickSearchOutput } from 'referrers/clicks-search-outputs';
import { SearchLookup } from 'referrers/search-input-lookup';

export interface IReferrerCrawlOutput extends ICrawlOutput {
    domain: string,    
    url: string ,
    lang_codes: string,
    search_inputs?: SearchLookup | string,
    search_clicks?: ClickSearchOutput | string,
    html?: string | HtmlOutput,    
    status: number,
    start: Date,
    end: Date,
    runId: string
}
