import connect from '../db/connection';
import * as ReferrersController from '../controllers/referrers';
import * as MananagerController from '../controllers/manager';
import * as Consts from '../shared/constants';
import * as Utils from '../shared/utils';
import * as Config from '../config';

const db: string = `mongodb://${Config.Database.db_host}:${Config.Database.db_port}/${Config.Database.db_name}`;

connect(db);

const batchSize = 5;

const createDB = async () => {

    try {

        const testItem = await ReferrersController.getDomainsBatch({}, 1);

        if(!testItem)
            throw(new Error(`db cannot be reached.`))

        if(testItem.length && testItem.length > 0)
            throw(new Error(`db has already been initiated.`))
        
        const inputJsonRaw = await Utils.readFromFileAsync(Config.Database.db_init_file_path);
        const inputJson = JSON.parse(inputJsonRaw);

        for (let i = 0; i < inputJson.length; i += batchSize) {		
                
            let batch = inputJson.slice(i, i + batchSize);       
            let promises = batch.map((el: any) => ReferrersController.create(el.rank, el.url, Consts.CRAWL_STATUS.NOT_SET));            
            await Promise.all(promises);               
        }
    
    } catch (error) {
        throw(error);
    }
    
}

const createCrawlerManager = async () =>
{
    try {
        
       return await MananagerController.create();
    
    } catch (error) {
        throw(error);        
    }
}

(async ()=> {

    try {

        console.log(`creating db manager...`);        
        const manager = await createCrawlerManager();
        console.log(`${manager && manager.doWork ? 'manager created.' : 'only one manager is allowed per db.'}`);
            
        console.log(`creating db...`);        
        await createDB();
        console.log(`db created.`);

    } catch (error) {
        console.log(`error: ${error.message || undefined}`);   
    }
    finally{
        process.exit(0);
    }

})();