import WorkItems from '../models/workitems';

export const create = async (workItem: object) : Promise<any> => {

    return new Promise((resolve, reject) => {

        try {
            WorkItems.create(workItem, (err: Error, el: object) => {
                if (err) {                    
                    return reject(err);
                }            
                
                return resolve(el);
            });   
        } catch (error) {            
            return reject(error);
        }       
    })        
}

export const getWorkItems = async (criteria: object, sortCriteria: object, size: number) : Promise<Array<any>> => {

    try {
        
        let work_items = [];        
        const work_items_raw = await WorkItems.find(criteria).sort(sortCriteria).limit(size);
                   
        if(work_items_raw) 
        {       
            for (let i in work_items_raw){
                let item = work_items_raw[i] as any;
                work_items.push(item.toWeb());
            }               
        }    
       
        return work_items;

    } catch (err) {
        throw(err);
    }    
}

export const updateWorkItem = async (filter: object, update: object) : Promise<void> =>  {
    await WorkItems.updateOne(filter, update);    
}

export const workItemExists = async (criteria: object) : Promise<boolean> => {

    return new Promise((resolve, reject) => {

        WorkItems.exists(criteria, (err: Error, doesItExist: boolean) => {
            if (err) {
              return reject(err);
            } else {
              return resolve(doesItExist);
            }
          });

    });
    
}

export const updateLastWorkItem = async (filter: object, update: object) : Promise<boolean> => {

    try {
   
        const lastWorkItemMarchingFilter = await getWorkItems(filter, {createdAt: -1}, 1);

        if(lastWorkItemMarchingFilter.length > 0)
        {
            await WorkItems.findByIdAndUpdate(lastWorkItemMarchingFilter[0].id, update);  
            return true;
        }
        else
        return false;
             
    } catch (error) {
        throw(error);
    }

}