import SearchEndpoints from '../models/search-endpoints';
import { ISearchEndpoint } from '../interfaces/referrers/search-endpoint.interface';

export const create = async (search_endpoint: ISearchEndpoint) : Promise<ISearchEndpoint> => {

    const exists = await searchEndpointExists(search_endpoint.domain, search_endpoint.url);

    if(exists && exists === true)
        return;
    
    return new Promise((resolve, reject) => {

        try {
            SearchEndpoints.create(search_endpoint, (err: Error, el: ISearchEndpoint) => {
                if (err) {                  
                    return reject(err);
                }                           
                return resolve(el);
            });   
        } catch (error) {            
            reject(error);
        }       
    });            

}

export const searchEndpointExists = async (searchEnpointDomain:string, searchEnpointUrl:string) : Promise<boolean> => {

    return new Promise((resolve, reject) => {

        SearchEndpoints.exists({ domain: searchEnpointDomain, url: searchEnpointUrl }, (err: Error, doesItExist: boolean) => {
            if (err) {
              reject(err);
            } else {
              resolve(doesItExist);
            }
          });

    });
    
}

export const getSearchEndpoint = async (criteria: any, sort: any, size: number) : Promise <Array<ISearchEndpoint>> => {

    let search_endpoints_raw, findCriteria, sortCriteria;

    findCriteria = criteria;
    sortCriteria = sort;

    let search_endpoints = [];

    search_endpoints_raw = await SearchEndpoints.find(findCriteria).sort(sortCriteria).limit(size);

    if(search_endpoints_raw) 
    {       
        for (let i in search_endpoints_raw){
            let item = search_endpoints_raw[i] as any;
            search_endpoints.push(item.toWeb());
        }               
    }    
    
    return search_endpoints;
}