import Referrers from '../models/referrers';
import { ICrawlInput } from '../interfaces/core/crawl-input.interface';

export const create = async (rank: number, domain: string, status: number, lastRunId?: string)                  
    : Promise<any> => {
        return new Promise ((resolve, reject) => {
            try {
                Referrers.create({
                    rank,
                    domain,
                    status,
                    lastRunId                    
                }, (err: any, el: any) => {
                    if (err) {                       
                        return reject(err);
                    }                            
                    return resolve(el);
                });   
            } catch (error) {            
                reject(error);
            }       
        });
};

export const getDomainsBatch = async (criteria: object, size: number) : Promise<Array<any>> => {

    try {
        
        const referrers = [];                
        const referrers_raw = await Referrers.find(criteria).sort({updatedAt: 1}).limit(size);  
                      
        if(referrers_raw) 
        {       
            for (let i in referrers_raw) {
                let item = referrers_raw[i] as any;
                referrers.push(item.toWeb());               
            }               
        }    
       
        return referrers;

    } catch (err) {
        throw(err);
    }    
}

export const updateOne = async (filter: object, update: ICrawlInput) : Promise<void> => {
    await Referrers.updateOne(filter, update);    
}