import Payloads from '../models/payloads';
import { IPayload } from '../interfaces/core/payload.interface';

export const create = async (payload: IPayload) : Promise<any> => {

    const exists = await payloadExists(payload.hash);

    if(exists && exists === true)
        return;

    return new Promise((resolve, reject) => {

        try {
            Payloads.create(payload, (err: Error, el: any) => {
                if (err) {
                    console.log(err); 
                    return reject(err);
                }                            
                return resolve(el);
            });   
        } catch (error) {            
            reject(error);
        }       
    })        
}

export const payloadExists = async (hash: string) : Promise<boolean> => {

    return new Promise((resolve, reject) => {

        Payloads.exists({hash}, function(err: Error, doesItExist: boolean) {
            if (err) {
              reject(err);
            } else {
              resolve(doesItExist);
            }
          });

    });
    
}
