
import Manager from '../models/manager';

export const create = async () : Promise<any> => {
    
    const existingManager = await getManagerWhere();

    if(existingManager && existingManager.doWork)
        return undefined;

    return new Promise((resolve, reject) => {
        try {
            Manager.create({doWork: 1}, (err: Error, el: any) => {
                if (err) {                    
                    return reject(err);
                }                               
                return resolve(el);
            });   
        } catch (error) {          
            reject(error);
        }       
    });            
}

export const getManagerWhere = async (whereCriteria: any = {}) : Promise<any> => {
    try {
        let crawler_manager = await Manager.findOne(whereCriteria);
        return crawler_manager; 
    } catch (err) {
        throw(err)
    }     
}

export const updateOne = async (whereCriteria: any, updateCriteria: any) => {
    await Manager.updateOne(whereCriteria, updateCriteria);    
}