import Crawls from '../models/crawls';
import { IReferrerCrawlOutput } from '../interfaces/referrers/referrer-crawl-output.interface';

export const create = async (output: IReferrerCrawlOutput) : Promise<IReferrerCrawlOutput> => {
  return new Promise((resolve, reject) => {

      try {
          Crawls.create(output, (err: Error, el: IReferrerCrawlOutput) => {
              if (err) {                 
                  return reject(err);
              }                          
              return resolve(el);
          });   
      } catch (error) {          
          reject(error);
      }       
  });        
}

export const getCrawls = async (criteria: object, size: number) : Promise<Array<IReferrerCrawlOutput>> => {
  
  const crawls = [];
  const crawls_raw = await Crawls.find(criteria).sort({createdAt: 1}).limit(size);

  if(crawls_raw) 
  {       
      for (let i in crawls_raw){
          let item = crawls_raw[i] as any;
          crawls.push(item.toWeb());
      }               
  }    
  
  return crawls;
}

export const allCrawlOutputsWhere = async (whereCriteria : object, limit: number) : Promise<Array<IReferrerCrawlOutput>> => {

  return new Promise ((resolve, reject) => {

    Crawls.find(whereCriteria, (err: Error, urls: any) => {
      if (err) {
          return reject(err);
      } else {
        return resolve(urls);
      }
    }).limit(limit);

  });

};

// export const addCrawlOutput = async (url: String, html: string, text: string, httpCode: number, etag: string, type: string, links: Array<string>, ts: number, length: string, crawlStatus: number) : Promise<any> => {

//     return new Promise ((resolve, reject) => {
//         try {
//             CVEUrl.create({
//                 url,
//                 html,
//                 text,
//                 httpCode,
//                 etag,
//                 type,
//                 links,
//                 ts,
//                 length,
//                 crawlStatus  
//             }, (err: any, el: any) => {
//                 if (err) {
//                     console.log(err); 
//                     return reject(err);
//                 }                            
//                 return resolve(el);
//             });   
//         } catch (error) {            
//             reject(error);
//         }       
//     });
// };

// export const urlExists = async function(url: string) : Promise<any> {

//   return new Promise((resolve, reject) => {
//     CVEUrl.exists({url}, function(err, result) {
//         if (err) {
//           reject(err);
//         } else {
//           resolve(result);
//         }
//       });
//   });  
// }