import Audits from '../models/audits';
import { IReferrerAudit } from '../interfaces/referrers/audit.interface';

export const create = async (audit: IReferrerAudit)                  
    : Promise<any> => {
        return new Promise ((resolve, reject) => {
            try {
                Audits.create(audit, (err: Error, el: any) => {
                    if (err) {
                        console.log(err); 
                        return reject(err);
                    }                            
                    return resolve(el);
                });   
            } catch (error) {            
                reject(error);
            }       
        });
};

export const urlAuditExists = async (criteria: object) : Promise<boolean> => {

    return new Promise((resolve, reject) => {
        Audits.exists(criteria), (err: Error, doesItExist: boolean) => {
          if (err) {
            return reject(err);
          } else {
            return resolve(doesItExist);
          }
        }
    });  
}