export const Database = { 
    db_init_file_path:  './data/inputs/tranco_domains/tranco-NYJW.json',
    db_host: 'localhost',
    db_port: '27017',
    db_name: 'pie-test-db',
    db_user: '',
    db_password: ''     
 }

export const Crawler = {
    batchSize: 10000,
    maxWorkers: 10,
    loopInterval: 10000,
    workerTimeout: 300000
} 

export const IO = {
  outputsPath: './data/outputs'
} 

export const Browser = {      
    headless: true,
    args: [
        '--ignore-certificate-errors'+
        '--window-size=1920x1080' +
        '--no-sandbox=true' +
        '--disable-setuid-sandbox=true' +
        '--disable-dev-shm-usage=true' +
        '--disable-accelerated-2d-canvas=true' +
        '--disable-gpu=true'
    ]
  }

export const ReferrersCrawler = {
  searchJobsBatch: 1,
  pageTimeout: 60 * 1000,
  defaultLanguageCode: 'en',
  searchQuery: 'JELLYBEANS',
  largePayloadsSize: 15000,
  searchEndpointsMatchPattern: /\{.*?\}/g,
  findSearchEndpointRegex: /"potentialAction":.*?"target" *: *"([^"]+?)"/gmi,
  languageInputsPath: './data/inputs/language/mapped_langs.json',
  outputsPath: './data/outputs',
  largePayloadsPath: './data/outputs/payloads',
  //https://en.wikipedia.org/wiki/List_of_cheeses
  crawlRunId: 'Cheddar',
  storeLocal: 0
}

